﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Magazyny" %>
<%@ Import Namespace="Soneta.Towary" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<script runat="server">
        
    public class Porównanie : IComparer {
    
        public int Compare(object x, object y) {
            DefDokHandlowego def1 = (DefDokHandlowego)x;
            DefDokHandlowego def2 = (DefDokHandlowego)y;
            int cmp;

            cmp = def1.KierunekMagazynu.CompareTo(def2.KierunekMagazynu);
            if (cmp != 0) return -cmp;

            string s1 = def1.DefinicjaEwidencji != null ? def1.DefinicjaEwidencji.Symbol : "(brak)";
            string s2 = def2.DefinicjaEwidencji != null ? def2.DefinicjaEwidencji.Symbol : "(brak)";
            cmp = string.Compare(s1, s2);
            if (cmp != 0) return cmp;

            return string.Compare(def1.Symbol, def2.Symbol);
        }

    }
    
    public class Zapis {
        readonly Magazyn magazyn;
        readonly string typ;
        readonly string definicja;
        readonly string ewidencja;
        readonly decimal wartość;
        readonly int numer;
        public bool Ostatni = false;

        public Zapis(Magazyn magazyn, string typ, string definicja, string ewidencja, int numer, decimal wartość) {
            this.magazyn = magazyn;
            this.typ = typ;
            this.definicja = definicja;
            this.ewidencja = ewidencja;
            this.numer = numer;
            this.wartość = wartość;
        }

        public string Typ {
            get { return typ; }
        }

        public Magazyn Magazyn {
            get { return magazyn; }
        }

        public string Definicja {
            get { return definicja; }
        }

        public string Ewidencja {
            get {
                return ewidencja;
            }
        }

        public decimal Wartość1 {
            get { return numer == 1 ? wartość : Soneta.Tools.Math.BlankDecimal; }
        }

        public decimal Wartość2 {
            get { return numer == 2 ? wartość : Soneta.Tools.Math.BlankDecimal; }
        }

        public decimal Wartość3 {
            get { return numer == 3 ? wartość : Soneta.Tools.Math.BlankDecimal; }
        }

        public int Numer {
            get { return numer; }
        }
    }

    FromTo okres;

    [Context]
    public FromTo Okres {
        get { return okres; }
        set { okres = value; }
    }

    Magazyn magazyn;

    [Context]
    public Magazyn Magazyn {
        get { return magazyn; }
        set { magazyn = value; }
    }

    HandelModule hm;
    MagazynyModule mm;
    StanMagazynuWorker stanPrzed = new StanMagazynuWorker();
    StanMagazynuWorker stanPo = new StanMagazynuWorker();
    SortedList list = new SortedList(new Porównanie());
    ArrayList arr = new ArrayList();

    void dc_ContextLoad(object sender, EventArgs e) {
        arr.Clear();
        hm = HandelModule.GetInstance(dc);
        mm = hm.Magazyny;

        if (Okres.From.IsNull)
            stanPrzed.Data = Okres.From;
        else
            stanPrzed.Data = Okres.From - 1;
        stanPo.Data = Okres.To;

        if (Magazyn != null)
            sumujMagazyn(Magazyn);
        else {
            foreach (Magazyn magazyn in mm.Magazyny.GetGrantedView())
                sumujMagazyn(magazyn);
        }

        Grid.DataSource = arr;

        DokumentyParams dp = dc.Context[typeof(DokumentyParams), false] as DokumentyParams;
        this.ReportHeader.Title += WydrukiTools.WydrukiObrotyWgDokumentowLista.FilterInfo(dp); 

    }

    decimal suma1, suma2;
    KierunekPartii kierunek;
    string ewidencja;

    void sumujMagazyn(Magazyn magazyn) {
        System.Diagnostics.Trace.WriteLine(magazyn);
        list.Clear();

        //
        // Najpierw podsumować stan przed i stan po
        //
        stanPrzed.Magazyn = magazyn;
        stanPo.Magazyn = magazyn;
        decimal wartośćPrzed = 0, wartośćPo = 0, wartośćPrzedM = 0, wartośćPoM = 0;
        decimal wartośćMagPrzed = 0, wartośćMagPo = 0;

        foreach (Towar towar in mm.Towary.Towary) {
            stanPrzed.Towar = towar;
            stanPo.Towar = towar;

            if (!Soneta.Tools.Math.IsBlank(stanPrzed.WartośćSalda))
                wartośćPrzed += stanPrzed.WartośćSalda;
            if (!Soneta.Tools.Math.IsBlank(stanPo.WartośćSalda))
                wartośćPo += stanPo.WartośćSalda;
            if (!Soneta.Tools.Math.IsBlank(stanPrzed.WartośćMinus))
                wartośćPrzedM += stanPrzed.WartośćMinus;
            if (!Soneta.Tools.Math.IsBlank(stanPo.WartośćMinus))
                wartośćPoM += stanPo.WartośćMinus;
            if (!Soneta.Tools.Math.IsBlank(stanPrzed.WartośćMagazynu))
                wartośćMagPrzed += stanPrzed.WartośćMagazynu;
            if (!Soneta.Tools.Math.IsBlank(stanPo.WartośćMagazynu))
                wartośćMagPo += stanPo.WartośćMagazynu;
        }

        //
        // Wczytać dokumenty hurtem
        //
        bool uwzględniajUsługi = false;
        
        SubTable st = new SubTable(mm.Handel.DokHandlowe.WgMagazyn[magazyn], Okres);
       Soneta.Business.View vw = st.CreateView();
        vw.Condition &= new FieldCondition.Equal("TypPartii", TypPartii.Magazynowy);
        vw.Condition &= new FieldCondition.NotEqual("KierunekMagazynu", KierunekPartii.Brak);
        foreach (DokumentHandlowy dok in vw) {
            if (dok.KierunekMagazynu == KierunekPartii.Przychód) {
                foreach (PozycjaDokHandlowego poz in dok.Pozycje) {
                    if (!uwzględniajUsługi &&
                       poz.Towar != null &&
                       poz.Towar.Typ != TypTowaru.Produkt &&
                       poz.Towar.Typ != TypTowaru.Towar) continue;
                    switch (dok.Definicja.MomentMagazynu) {
						case MomentMagazynu.PodczasZatwierdzania:
						case MomentMagazynu.ZaPomocąRezerwacji:
							{
								if (dok.Zatwierdzony)
								{
									/***
									 * TASK: 6020. [6.2.2] /sbm
									 * 
									 * dodajPozycje(poz, poz.Suma.Netto);
									 */
									dodajPozycje(poz, poz.Korekta ? poz.ZmianaNetto : poz.Suma.Netto);
								}
								break;
							}
						case MomentMagazynu.PodczasZapisu:
							{
								/***
								 * TASK: 6020. [6.2.2] /sbm
								 * 
								 * dodajPozycje(poz, poz.Suma.Netto);
								 */
								dodajPozycje(poz, poz.Korekta ? poz.ZmianaNetto : poz.Suma.Netto);
								break;
							}
                    }
                }
            }
        }

        //
        // Podsumować rozchody
        //
        decimal przychódPo = 0, przychódPoMag = 0, przychódPoZam = 0, przychódPrzed = 0;
        st = mm.Obroty.WgMagazyn[magazyn];
        vw = st.CreateView();
        vw.Condition &= new FieldCondition.Contain("Data", Okres);
        vw.Condition &= new FieldCondition.NotEqual("Korekta", KorektaObrotu.StornoZasobu);
        vw.Condition &= new FieldCondition.Equal("Przychod.Typ", TypPartii.Magazynowy);
        foreach (Obrot ob in vw) {
            if (ob.Przychod.Data > Okres.To) {
                przychódPo += ob.Przychod.Wartosc;
                if (ob.Rozchod.Typ == TypPartii.Magazynowy)
                    przychódPoMag += ob.Przychod.Wartosc;
                if (ob.Rozchod.Typ == TypPartii.Zamówiony || ob.Rozchod.Typ == TypPartii.ZamówionyZasób)
                    przychódPoZam += ob.Przychod.Wartosc;
            }
            dodajDokument(ob.Rozchod.Dokument, ob.Przychod.Wartosc);
        }
       Soneta.Business.View vwPrzed = st.CreateView();
        Date from = mm.OkresyMag[Okres.From -1].Okres.From;
        Date to = Okres.From -1;
        vwPrzed.Condition &= new FieldCondition.Contain("Data", new FromTo(from, to));
        vwPrzed.Condition &= new FieldCondition.NotEqual("Korekta", KorektaObrotu.StornoZasobu);
        vwPrzed.Condition &= new FieldCondition.Equal("Przychod.Typ", TypPartii.Magazynowy);
        foreach (Obrot ob in vwPrzed) {
            if (ob.Rozchod.Data < Okres.From && Okres.Contains(ob.Przychod.Data)) {
                przychódPrzed += ob.Przychod.Wartosc;
            }
        }
        
        //
        // Przygotować dane do wydruku
        //
        arr.Add(new Zapis(magazyn, "Stan magazynu przed", "", "", 3, wartośćMagPrzed));
        //if (rozchódPrzed!=0)
        arr.Add(new Zapis(magazyn, "Wcześniejsze rozchody pokryte z bieżącego okresu", "", "", 3, przychódPrzed));
        if (wartośćPrzedM != 0)
            arr.Add(new Zapis(magazyn, "Stan ujemny przed", "", "", 3, wartośćPrzedM));
        //arr.Add(new Zapis(magazyn, "Stan przed (chronologicznie)", "", "", 3, wartośćPrzed));

        suma1 = suma2 = 0;
        kierunek = KierunekPartii.Brak;
        ewidencja = null;

        foreach (DictionaryEntry de in list) {
            DefDokHandlowego def = (DefDokHandlowego)de.Key;
            sprawdźWiersz(def);
            decimal d = (decimal)de.Value;
            suma1 += d;
            suma2 += d;
            string ew = def.DefinicjaEwidencji == null ? "(brak)" : def.DefinicjaEwidencji.Symbol;
            arr.Add(new Zapis(magazyn, 
                def.KierunekMagazynu==KierunekPartii.Przychód ? "Przychód" : "Rozchód",
                def.Symbol, ew, 1, d));
        }
        sprawdźWiersz(null);

        if (wartośćPoM != 0)
            arr.Add(new Zapis(magazyn, "Stan ujemny po", "", "", 3, wartośćPoM));
        //arr.Add(new Zapis(magazyn, "Stan po (chronologicznie)", "", "", 3, wartośćPo));
        //if (przychódPo!=0)
        arr.Add(new Zapis(magazyn, "Rozchody pokryte z przyszłego okresu", "", "", 3, przychódPo));
        arr.Add(new Zapis(magazyn, "Rozchody pokryte z przyszłego okresu magazynowe", "", "", 3, przychódPoMag));
        arr.Add(new Zapis(magazyn, "Rozchody pokryte z przyszłego okresu zamówione", "", "", 3, przychódPoZam));
        arr.Add(new Zapis(magazyn, "Stan magazynu po", "", "", 3, wartośćMagPo));
    }

    const string razem = "<center>--- razem ---</center>";

    void sprawdźWiersz(DefDokHandlowego def) {
        string k = kierunek == KierunekPartii.Przychód ? "Przychód" : "Rozchód";
        string ew = def == null ? "" :
			(def.DefinicjaEwidencji == null ? "(brak)" : def.DefinicjaEwidencji.Symbol);
        if (def == null || ewidencja == null || ew != ewidencja) {
            if (ewidencja != null) {
                ustawOstatni();
                arr.Add(new Zapis(magazyn,
					k,
					razem, ewidencja, 2, suma2));
            }
            ewidencja = ew;
            suma2 = 0;
        }
        if (def == null || def.KierunekMagazynu != kierunek) {
            if (kierunek != KierunekPartii.Brak) {
                ustawOstatni();
                arr.Add(new Zapis(magazyn,
					k,
					"", razem, 3, suma1));
            }
            if (def != null)
                kierunek = def.KierunekMagazynu;
            suma1 = 0;
        }
    }

    void ustawOstatni() {
        if (arr.Count > 0)
            ((Zapis)arr[arr.Count - 1]).Ostatni = true;
    }

    void dodajDokument(DokumentHandlowy dok, decimal value) {
        object v = list[dok.Definicja];
        if (v == null)
            list[dok.Definicja] = value;
        else
            list[dok.Definicja] = value + (decimal)v;
    }

    void dodajPozycje(PozycjaDokHandlowego poz, decimal value) {
        object v = list[poz.Dokument.Definicja];
        if (v == null)
            list[poz.Dokument.Definicja] = value;
        else
            list[poz.Dokument.Definicja] = value + (decimal)v;
    }

    void Grid_BeforeRow(object sender, RowEventArgs args) {
        Zapis zapis = (Zapis)args.Row;
        col1.BottomBorder = BorderStyles.Single;
        col2.BottomBorder = BorderStyles.Single;
        col3.BottomBorder = BorderStyles.Single;
        if (zapis.Ostatni) {
            switch (zapis.Numer) {
                case 1: col1.BottomBorder = BorderStyles.Double; break;
                case 2: col2.BottomBorder = BorderStyles.Double; break;
                case 3: col3.BottomBorder = BorderStyles.Double; break;
            }
        }
    }
    
</script>
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<title>Obroty wg ewidencji księgowej</title>
		<meta content="C#" name="CODE_LANGUAGE" />
		<meta content="JavaScript" name="vs_defaultClientScript" />
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
	</head>
	<body>
		<form action="#" method="post" runat="server">
			<ea:DataContext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" runat="server" title="Obroty wg ewidencji księgowej|</STRONG>"></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server" RowTypeName="Soneta.Towary.Towar,Soneta.Handel" GroupData0="Magazyn" GroupLine="Magazyn: {0}" onbeforerow="Grid_BeforeRow"><Columns>
<ea:GridColumn DataMember="Typ" Caption=" " Runat="server"></ea:GridColumn>
<ea:GridColumn Width="20" DataMember="Ewidencja" Runat="server"></ea:GridColumn>
<ea:GridColumn Runat="server" DataMember="Definicja" Width="20" Caption="Symbol"></ea:GridColumn>
<ea:GridColumn Runat="server" Align="Right" DataMember="Wartość1"
                        Format="{0:n}" Width="16" Caption="Wartość~ " id="col1"></ea:GridColumn>
<ea:GridColumn Runat="server" Align="Right" DataMember="Wartość2" Width="16" Caption="Wartość~ "
                        Format="{0:n}" id="col2"></ea:GridColumn>
<ea:GridColumn Runat="server" Align="Right" DataMember="Wartość3" Width="16" Caption="Wartość~ "
                        Format="{0:n}" id="col3"></ea:GridColumn>
</Columns>
</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server" PrintDate="true" PrintTime="true"></eb:ReportFooter>
		</form>
	</body>
</html>

